# ,family="CMU Serif"
par(mfrow=c(1,2))

# costs
cp <- seq(0,0.3, length.out=50)
xp <- 0.1
beta <- 4.0
alpha <- (xp*(beta-2)+1)/(1-xp)
cg <- 0.02
p.ref <- pbeta((1-cp)/2,alpha,beta)
p.init <- 1- pbeta((1+cp)/2,alpha,beta)
xg <- (p.ref*(cg-1) - p.init*(cg+1) +1)/(2*(1-p.ref-p.init))
plot(cp,xg,type="l", ylim=c(0.4,1), lwd=2, ylab="Minimal Preference of Gov for Policy to Propose It", xlab="Costs of DD Usage for People")
cg <- 0.04
xg <- (p.ref*(cg-1) - p.init*(cg+1) +1)/(2*(1-p.ref-p.init))
points(cp,xg,lwd=2, lty=2, type="l")
legend(0.15,0.9,lty=c(1,2), lwd=2, legend=c(expression("Low cost for G;"~c[G]~"low"),expression("High cost for G;"~c[G]~"high")), bty="n")
# pref P
cp <- 0.1
xp <- seq(0,0.5, length.out=50)
beta <- 4.0
alpha <- (xp*(beta-2)+1)/(1-xp)
cg <- 0.05
p.ref <- pbeta((1-cp)/2,alpha,beta)
p.init <- 1- pbeta((1+cp)/2,alpha,beta)
xg <- (p.ref*(cg-1) - p.init*(cg+1) +1)/(2*(1-p.ref-p.init))
plot(xp,xg,type="l", ylim=c(0.4,1), lwd=2, ylab="Minimal Preference of Gov for Policy to Propose It", xlab="Preference of the People")
cp <- 0.3
p.ref <- pbeta((1-cp)/2,alpha,beta)
p.init <- 1- pbeta((1+cp)/2,alpha,beta)
xg <- (p.ref*(cg-1) - p.init*(cg+1) +1)/(2*(1-p.ref-p.init))
points(xp,xg,lwd=2, lty=2, type="l")
legend(0.27,0.89,lty=c(1,2), lwd=2, legend=c(expression("High DD;"~c[P]~"low"), expression("Low DD;"~c[P]~"high")), bty="n")


